/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.syncing.ui.wizards;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.StringUtil;
import com.aptana.syncing.ui.wizards.Messages;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExportConnectionsPage
extends WizardPage {
    private Text filePathText;
    private Button browseButton;
    private Button overwriteButton;

    protected ExportConnectionsPage() {
        super("exportConnections");
    }

    public IPath getLocation() {
        return Path.fromOSString((String)this.filePathText.getText());
    }

    public boolean isOverwritingExistingFile() {
        return this.overwriteButton.getSelection();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        Label label = new Label(main, 0);
        label.setText(Messages.ExportConnectionsPage_LBL_File);
        this.filePathText = new Text(main, 2048);
        this.filePathText.setText(Platform.getPreferencesService().getString("com.aptana.syncing.ui", "EXPORT_INITIAL_PATH", "", null));
        this.filePathText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.filePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportConnectionsPage.this.validate();
            }
        });
        this.browseButton = new Button(main, 8);
        this.browseButton.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportConnectionsPage.this.browse();
            }
        });
        Group group = new Group(main, 0);
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        group.setText(Messages.ExportConnectionsPage_LBL_Options);
        this.overwriteButton = new Button((Composite)group, 32);
        this.overwriteButton.setText(Messages.ExportConnectionsPage_LBL_OverwriteWithoutWarning);
        this.overwriteButton.setSelection(Platform.getPreferencesService().getBoolean("com.aptana.syncing.ui", "OVEWRITE_FILE_WITHOUT_WARNING", false, null));
        this.setTitle(Messages.ExportConnectionsPage_Title);
        this.setDescription(Messages.ExportConnectionsPage_Description);
        this.setControl((Control)main);
        this.validate();
    }

    private void browse() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        String result = dialog.open();
        if (result != null) {
            this.filePathText.setText(result);
            this.validate();
        }
    }

    private void validate() {
        String error = null;
        String path = this.filePathText.getText();
        if (StringUtil.isEmpty((String)path)) {
            error = Messages.ExportConnectionsPage_ERR_EmptyFile;
        } else {
            File file = new File(path);
            if (file.isDirectory()) {
                error = Messages.ExportConnectionsPage_ERR_Directory;
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }
}

